package gov.va.genisis2.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.common.enums.RefreshStatusEnum;
import gov.va.genisis2.converter.RefreshHistoryConverter;
import gov.va.genisis2.dao.IRefreshHistoryDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.RefreshHistory;

import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class UserRefreshHistoryDaoTest extends AbstractMockMvcTests {

	/** The userRefreshHistoryDao. */
	@Autowired
	private IRefreshHistoryDao userRefreshHistoryDao;
	
	@Autowired
	private RefreshHistoryConverter userRefreshHistoryConverter;

	/**
	 * Test createUserRefreshHistory.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test(expected = GenisisDAOException.class)
	@Ignore
	public void test1CreateUserRefreshHistoryNullEntity() throws GenisisDAOException {
		userRefreshHistoryDao.createUserRefreshHistory(null);
	}
	
	/**
	 * Test createUserRefreshHistory.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test(expected = DataIntegrityViolationException.class)
	@Ignore
	public void test2CreateUserRefreshHistory_Null() throws GenisisDAOException {
		userRefreshHistoryDao.createUserRefreshHistory(new RefreshHistory());
	}
	
	/**
	 * Test createUserRefreshHistory.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	@Ignore
	public void test3CreateUpdateUserRefreshHistory() throws GenisisDAOException {
		RefreshHistory userRefreshHistory = userRefreshHistoryConverter.populateUserRefreshHistory("test", "Users");
		int id = userRefreshHistoryDao.createUserRefreshHistory(userRefreshHistory);
		assertTrue(id > 0);
		
		userRefreshHistory.setId(id);
		userRefreshHistoryConverter.populateUserRefreshHistory(userRefreshHistory);
		RefreshHistory updatedEntity = userRefreshHistoryDao.updateUserRefreshHistory(userRefreshHistory);
		
		assertNotNull(updatedEntity.getEndDate());
		assertEquals(RefreshStatusEnum.COMPLETED.getDesc(), updatedEntity.getStatus());
	}

	/**
	 * Test updateUserRefreshHistory.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test(expected = IllegalStateException.class)
	@Ignore
	public void test4UpdateUserRefreshHistory_Null() throws GenisisDAOException {
		RefreshHistoryDao dao = new RefreshHistoryDao();
	//TODO	dao.setSessionFactory(null);
		userRefreshHistoryDao.updateUserRefreshHistory(new RefreshHistory());
	}

	/**
	 * Test getLatestUserRefreshHistory.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	@Ignore
	public void test5GetLatestUserRefreshHistory() throws GenisisDAOException {
		assertNotNull(userRefreshHistoryDao.getLatestUserRefreshHistory());
	}

	@Test(expected = GenisisDAOException.class)
	@Ignore
	public void test6GetLatestUserRefreshHistory_Error() throws GenisisDAOException {
		RefreshHistoryDao dao = new RefreshHistoryDao();
	//TODO	dao.setSessionFactory(null);
		dao.getLatestUserRefreshHistory();
	}
}
